/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.itemgroup;

import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.gui.ItemGroupButton;
import io.wispforest.owo.itemgroup.gui.ItemGroupTab;
import io.wispforest.owo.util.pond.OwoItemExtensions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.impl.item.group.ItemGroupExtensions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7417;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class OwoItemGroup
extends class_1761 {
    public static final BiConsumer<class_1792, class_2371<class_1799>> DEFAULT_STACK_GENERATOR = (item, stacks) -> stacks.add((Object)item.method_7854());
    protected static final ItemGroupTab PLACEHOLDER_TAB = new ItemGroupTab(Icon.of((class_1935)class_1802.field_8162), (class_2561)class_2561.method_43473(), bruh -> {}, ItemGroupTab.DEFAULT_TEXTURE, false);
    public final List<ItemGroupTab> tabs = new ArrayList<ItemGroupTab>();
    public final List<ItemGroupButton> buttons = new ArrayList<ItemGroupButton>();
    private int selectedTab = 0;
    private boolean initialized = false;
    private int tabStackHeight = 4;
    private int buttonStackHeight = 4;
    private class_2960 customTexture = null;
    private boolean useDynamicTitle = true;
    private boolean displaySingleTab = false;

    protected OwoItemGroup(class_2960 id) {
        super(OwoItemGroup.createTabIndex(), String.format("%s.%s", id.method_12836(), id.method_12832()));
    }

    @ApiStatus.Internal
    protected OwoItemGroup(int index, String name) {
        super(index, name);
    }

    public static Builder builder(class_2960 id, Supplier<class_1799> iconSupplier) {
        return new Builder(id, iconSupplier);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this.setup();
        }
        if (this.tabs.size() == 0) {
            this.tabs.add(PLACEHOLDER_TAB);
        }
        this.initialized = true;
    }

    public void addButton(ItemGroupButton button) {
        this.buttons.add(button);
    }

    public void addTab(Icon icon, String name, @Nullable class_6862<class_1792> contentTag, class_2960 texture, boolean primary) {
        this.tabs.add(new ItemGroupTab(icon, ButtonDefinition.tooltipFor(this, "tab", name), contentTag == null ? stacks -> {} : stacks -> class_2378.field_11142.method_10220().filter(item -> item.method_40131().method_40220(contentTag)).map(class_1792::method_7854).forEach(arg_0 -> stacks.add(arg_0)), texture, primary));
    }

    public void addTab(Icon icon, String name, @Nullable class_6862<class_1792> contentTag, boolean primary) {
        this.addTab(icon, name, contentTag, ItemGroupTab.DEFAULT_TEXTURE, primary);
    }

    @Deprecated
    public void addTab(Icon icon, String name, @Nullable class_6862<class_1792> contentTag, class_2960 texture) {
        this.addTab(icon, name, contentTag, texture, false);
    }

    @Deprecated
    public void addTab(Icon icon, String name, @Nullable class_6862<class_1792> contentTag) {
        this.addTab(icon, name, contentTag, ItemGroupTab.DEFAULT_TEXTURE, false);
    }

    protected void setCustomTexture(class_2960 texture) {
        this.customTexture = texture;
    }

    protected void setTabStackHeight(int tabStackHeight) {
        this.tabStackHeight = tabStackHeight;
    }

    protected void setButtonStackHeight(int buttonStackHeight) {
        this.buttonStackHeight = buttonStackHeight;
    }

    protected void displaySingleTab() {
        this.displaySingleTab = true;
    }

    protected void keepStaticTitle() {
        this.useDynamicTitle = false;
    }

    protected abstract void setup();

    public void method_7738(class_2371<class_1799> stacks) {
        if (!this.initialized) {
            throw new IllegalStateException("o\u03c9o item group not initialized, was 'initialize()' called?");
        }
        this.getSelectedTab().contentSupplier().accept(stacks);
        class_2378.field_11142.method_10220().filter(item -> item.method_7859() == this && ((OwoItemExtensions)item).owo$tab() == this.selectedTab).forEach(item -> ((OwoItemExtensions)item).owo$stackGenerator().accept((class_1792)item, stacks));
    }

    public void setSelectedTab(int selectedTab) {
        this.selectedTab = selectedTab;
    }

    public ItemGroupTab getSelectedTab() {
        return this.tabs.get(this.selectedTab);
    }

    public int getSelectedTabIndex() {
        return this.selectedTab;
    }

    public class_2960 getCustomTexture() {
        return this.customTexture;
    }

    public int getTabStackHeight() {
        return this.tabStackHeight;
    }

    public int getButtonStackHeight() {
        return this.buttonStackHeight;
    }

    public boolean shouldDisplayTabNamesAsTitle() {
        return this.useDynamicTitle && (this.tabs.size() > 1 || this.shouldDisplaySingleTab());
    }

    public boolean shouldDisplaySingleTab() {
        return this.displaySingleTab;
    }

    public List<ItemGroupButton> getButtons() {
        return this.buttons;
    }

    public ItemGroupTab getTab(int index) {
        return index < this.tabs.size() ? this.tabs.get(index) : null;
    }

    private static int createTabIndex() {
        ((ItemGroupExtensions)class_1761.field_7931).fabric_expandArray();
        return class_1761.field_7921.length - 1;
    }

    public static class Builder {
        private final class_2960 id;
        private final Supplier<class_1799> iconSupplier;
        private Consumer<OwoItemGroup> initializer = owoItemGroup -> {};
        private int tabStackHeight = 4;
        private int buttonStackHeight = 4;
        @Nullable
        private class_2960 customTexture = null;
        private boolean useDynamicTitle = true;
        private boolean displaySingleTab = false;

        private Builder(class_2960 id, Supplier<class_1799> iconSupplier) {
            this.id = id;
            this.iconSupplier = iconSupplier;
        }

        public Builder initializer(Consumer<OwoItemGroup> initializer) {
            this.initializer = initializer;
            return this;
        }

        public Builder tabStackHeight(int tabStackHeight) {
            this.tabStackHeight = tabStackHeight;
            return this;
        }

        public Builder buttonStackHeight(int buttonStackHeight) {
            this.buttonStackHeight = buttonStackHeight;
            return this;
        }

        public Builder customTexture(@Nullable class_2960 customTexture) {
            this.customTexture = customTexture;
            return this;
        }

        public Builder disableDynamicTitle() {
            this.useDynamicTitle = false;
            return this;
        }

        public Builder displaySingleTab() {
            this.displaySingleTab = true;
            return this;
        }

        public OwoItemGroup build() {
            return new OwoItemGroup(this.id){

                public class_1799 method_7750() {
                    return iconSupplier.get();
                }

                @Override
                protected void setup() {
                    initializer.accept(this);
                    this.setTabStackHeight(tabStackHeight);
                    this.setButtonStackHeight(buttonStackHeight);
                    this.setCustomTexture(customTexture);
                    if (!useDynamicTitle) {
                        this.keepStaticTitle();
                    }
                    if (!displaySingleTab) {
                        this.displaySingleTab();
                    }
                }
            };
        }
    }

    public static interface ButtonDefinition {
        public Icon icon();

        public class_2960 texture();

        public String getTranslationKey(String var1);

        public static class_2561 tooltipFor(class_1761 group, String component, String componentName) {
            String string;
            class_7417 class_74172 = group.method_7737().method_10851();
            if (class_74172 instanceof class_2588) {
                class_2588 translatable = (class_2588)class_74172;
                string = translatable.method_11022();
            } else {
                string = group.method_7737().getString();
            }
            String groupTranslationKey = string;
            return class_2561.method_43471((String)(groupTranslationKey + "." + component + "." + componentName));
        }
    }
}

